/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_inv ( result, data ) ;

  parameter lpm_type = "lpm_inv" ;
  parameter lpm_width = 4 ;
  parameter polar_data = "NORMAL" ;
  parameter polar_result = "NORMAL" ;

  input  [lpm_width-1:0] data ;
  output [lpm_width-1:0] result ;

  wire   [lpm_width-1:0] data ;
  reg    [lpm_width-1:0] result ;
  reg    [lpm_width-1:0] pdata ;

  always @(data)
    begin
      pdata <= #1 (polar_data == "INVERT")?~data:data ;
    end

  always @(pdata)
    begin
      result = (polar_result == "INVERT")?pdata:~pdata ;
    end

endmodule // lpm_inv
`ifdef SYNTH
`else
`endcelldefine
`endif
 
